// Funzione catalogo messier

function messier_cat(catnum,name,cons,ra_h,ra_m,ra_s,de_g,de_p,de_ss,mpra_h,mpra_m,mpra_s, mpde_g,mpde_p,mpde_ss,ra_h1,ra_m1,ra_s1,sgn_dec,de_g1,de_p1,de_ss1,sgn_h,h_g,h_p,h_ss,a_g,a_p,a_ss,sgn_e,laec_g,laec_p,laec_ss,loec_g,loec_p,loec_ss,mg,dist_al,type,dimapp,dimreal,sorg_cat,meri_cat,tram_cat) 
{
  	this.catnum = catnum;
  	this.name = name;
  	this.cons = cons;

  	this.ra_h = ra_h;
	this.ra_m = ra_m;
	this.ra_s = ra_s;

  	this.de_g = de_g;
	this.de_p = de_p;
	this.de_ss = de_ss;
	
  	this.mpra_h = mpra_h;
	this.mpra_m = mpra_m;
	this.mpra_s = mpra_s;

  	this.mpde_g = mpde_g;
	this.mpde_p = mpde_p;
	this.mpde_ss = mpde_ss;

  	this.ra_h1 = ra_h1;
	this.ra_m1 = ra_m1;
	this.ra_s1 = ra_s1;

	this.sgn_dec = sgn_dec;
  	this.de_g1 = de_g1;
	this.de_p1 = de_p1;
	this.de_ss1 = de_ss1;
	
	this.sgn_h = sgn_h;
  	this.h_g = h_g;
	this.h_p = h_p;
	this.h_ss = h_ss;
	
  	this.a_g = a_g;
	this.a_p = a_p;
	this.a_ss = a_ss;
	
	this.sgn_e = sgn_e;
  	this.laec_g = laec_g;
	this.laec_p = laec_p;
	this.laec_ss = laec_ss;
	
  	this.loec_g = loec_g;
	this.loec_p = loec_p;
	this.loec_ss = loec_ss;
	
  	this.mg = mg;
	this.dist_al = dist_al;
  	this.type = type;
  	this.dimapp = dimapp;
  	this.dimreal = dimreal;

	this.sorg_cat = sorg_cat; 
	this.meri_cat = meri_cat; 
	this.tram_cat = tram_cat; 
	
}

// Funzione pulsante "stelle brillanti" 

function messier_h60(obj)
{  
	// Firma digitale 
	if (obj.FIRMA.value == "     Agostino Frosini  -  Javascript Software 2020  -") 
		{
		
// DATABASE CATALOGO STELLARE ---------------------------------------------------- 
		var messier = new Array(
  		
		// Catalogo Messier 
		new messier_cat("M1 - NGC 1952","Nebulosa del Granchio","Toro",5,34,31.94,22,0,52.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","6.2K AL","Nebulosa diffusa","6 x 4 arcmin","10.8 AL","---","---","---"),
		new messier_cat("M2 - NGC 7089","Ammasso globulare","Acquario",21,33,27.02,-0,-49,-23.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.46","38K AL","Ammasso globulare","2.1 arcmin","23.1 AL","---","---","---"),
		new messier_cat("M3 - NGC 5272","Ammasso globulare","Cani da caccia",13,42,11.62,28,22,38.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.19","33K AL","Ammasso globulare","4.6 arcmin","44.7 AL","---","---","---"),
		new messier_cat("M4 - NGC 6121","Ammasso globulare","Scorpione",16,23,35.23,-26,-31,-32.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.7","7.2K AL","Ammasso globulare","8.7 arcmin","18.1 AL","---","---","---"),
		new messier_cat("M5 - NGC 5904","Ammasso globulare","Serpente",15,18,33.23,2,4,51.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.65","24K AL","Ammasso globulare","3.5 arcmin","25.1 AL","---","---","---"),
		new messier_cat("M6 - NGC 6405","Ammasso aperto","Scorpione",17,40,19.93,-32,-15,-10.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.19","1.6K AL","Ammasso aperto","20 arcmin","9.2 AL","---","---","---"),
		new messier_cat("M7 - NGC 6475","Ammasso aperto","Scorpione",17,53,51.13,-34,-47,-34.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.29","980 AL","Ammasso aperto","80 arcmin","22.8 AL","---","---","---"),
		new messier_cat("M8 - NGC 6523 ","Nebulosa Laguna","Saggittario",18,03,36.96,-24,-22,-40.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.0","4.3K AL","Nebulosa diffusa","90 x 40 arcmin","113.6 AL","---","---","---"),
		new messier_cat("M9 - NGC 6333","Ammasso globulare","Ofiuco",17,19,11.78,-18,-30,-50.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.71","26K AL","Ammasso globulare","1.9 arcmin","14.4 AL","---","---","---"),
		new messier_cat("M10 - NGC 6254","Ammasso globulare","Ofiuco",16,57,09.05,-4,-6,-1.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.59","14K AL","Ammasso globulare","3.9 arcmin","16.3 AL","---","---","---"),
		new messier_cat("M11 - NGC 6705","Ammasso dell'anatra selvaggia","Scudo",18,51,5.05,-6,-16,-12.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.8","6.1K AL","Ammasso aperto","32 arcmin","57 AL","---","---","---"),
		new messier_cat("M12 - NGC 6218","Ammasso globulare Pallina di gomma","Ofiuco",16,47,14.18,-1,-56,-54.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.69","16K AL","Ammasso globulare","3.5 arcmin","16.1 AL","---","---","---"),
		new messier_cat("M13 - NGC 6205","Ammasso globulare Ercole","Ercole",16,41,41.64,36,27,40.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.78","23K AL","Ammasso globulare","3.4 arcmin","22.8 AL","---","---","---"),
		new messier_cat("M14 - NGC 6402","Ammasso globulare","Ofiuco",17,37,36.16,-3,-14,-45.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.59","30K AL","Ammasso globulare","2.6 arcmin","22.9 AL","---","---","---"),
		new messier_cat("M15 - NGC 7078","Ammasso globulare","Pegaso",21,29,58.33,12,10,1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.19","34K AL","Ammasso globulare","2.0 arcmin","19.7 AL","---","---","---"),
		new messier_cat("M16 - NGC 6611","Nebulosa Aquila","Serpente",18,18,48.01,-13,-48,-25.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.4","5.7K AL","Nebulosa diffusa","35 x 28 arcmin","58.1 AL","---","---","---"),
		new messier_cat("M17 - NGC 6618","Nebulosa Omega","Saggittario",18,20,47.04,-16,-10,-19.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.0","4.2K AL","Nebulosa diffusa","46 x 37 arcmin","56.7 AL","---","---","---"),
		new messier_cat("M18 - NGC 6613","Ammasso aperto Cigno nero","Saggittario",19,19,58.08,-17,-6,-7.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.0","4.2K AL","Ammasso aperto","5 arcmin","6.1 AL","---","---","---"),
		new messier_cat("M19 - NGC 6273","Ammasso globulare","Ofiuco",17,2,37.69,-26,-16,-4.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.76","29K AL","Ammasso globulare","2.6 arcmin","22 AL","---","---","---"),
		new messier_cat("M20 - NGC 6514","Nebulosa Trifida","Saggittario",18,2,42.0,-22,-58,-19.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.3","5.2K AL","Nebulosa diffusa","29 x 27 arcmin","43.9 AL","---","---","---"),
		new messier_cat("M21 - NGC 6531","Ammasso aperto Croce di Webb","Saggittario",18,4,12.96,-22,-29,-24.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.9","3.9K AL","Ammasso aperto","14.0 arcmin","16 AL","---","---","---"),
		new messier_cat("M22 - NGC 6556","Ammasso globulare del Gran Saggittario","Saggittario",18,36,23.95,-23,-54,-17.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.09","10K AL","Ammasso globulare","6.7 arcmin","20.4 AL","---","---","---"),
		new messier_cat("M23 - NGC 6494","Ammasso aperto","Saggittario",17,57,4.08,-18,-59,-6.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.5","2K AL","Ammasso aperto","29 arcmin","17.3 AL","---","---","---"),
		new messier_cat("M24 - NGC 6603","Ammasso aperto delle Caustiche","Saggittario",18,16,48.01,-18,-33,-0.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.6","12K AL","Ammasso aperto","6 arcmin","20.5 AL","---","---","---"),
		new messier_cat("M25 - NGC ----","Ammasso aperto","Saggittario",18,31,47.05,-19,-7,-1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.5","2K AL","Ammasso aperto","29 arcmin","17.1 AL","---","---","---"),
		new messier_cat("M26 - NGC 6694","Ammasso aperto","Scudo",18,45,18.01,-9,-22,-58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.0","5.2K AL","Ammasso aperto","7.0 arcmin","10.6 AL","---","---","---"),
		new messier_cat("M27 - NGC 6853","Nebulosa Manubrio","Volpetta",19,59,36.39,22,43,15.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.09","1.7K AL","Nebulosa planetaria","8 x 5.7 arcmin","4.0 AL","---","---","---"),
		new messier_cat("M28 - NGC 6626","Ammasso globulare","Saggittario",18,24,32.90,-24,-52,-11.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.78","18K AL","Ammasso globulare","3.9 arcmin","20.5 AL","---","---","---"),
		new messier_cat("M29 - NGC 6913","Ammasso aperto Torre di raffreddamento","Cigno",20,23,55.92,38,31,22.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.59","3.7K AL","Ammasso aperto","10.0 arcmin","10.9 AL","---","---","---"),
		new messier_cat("M30 - NGC 7099","Ammasso globulare Medusa","Capricorno",21,40,22.13,-23,-10,-47.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.19","26K AL","Ammasso globulare","2.1 arcmin","15.9 AL","---","---","---"),
		new messier_cat("M31 - NGC 224","Galassia di Andromeda","Andromeda",0,42,44.33,41,16,7.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.40","2.5M AL","Galassia a spirale","189.1 x 61.7 arcmin","139.6K AL","---","---","---"),
		new messier_cat("M32 - NGC 221","Galassia","Andromeda",0,42,41.83,40,51,54.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.10","2.5M AL","Galassia ellittica","8.5 x 6.5 arcmin","6.2K AL","---","---","---"),
		new messier_cat("M33 - NGC 598","Galassia Girandola","Triangolo",1,33,50.91,30,39,35.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.69","2.8M AL","Galassia a spirale","68.7 x 41.6 arcmin","56.1K AL","---","---","---"),
		new messier_cat("M34 - NGC 1039","Ammasso aperto","Perseo",2,42,5.04,42,45,43.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.19","1.6K AL","Ammasso aperto","35 arcmin","16.6 AL","---","---","---"),
		new messier_cat("M35 - NGC 2168","Ammasso aperto","Gemelli",6,8,54,24,19,58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.09","3K AL","Ammasso aperto","40 arcmin","34.6 AL","---","---","---"),
		new messier_cat("M36 - NGC 1960","Ammasso aperto Girandola","Auriga",5,36,18,24,8,24,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.0","4.3K AL","Ammasso aperto","10 arcmin","12.6 AL","---","---","---"),
		new messier_cat("M37 - NGC 2099","Ammasso aperto","Auriga",5,52,18,32,33,10.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.59","4.5K AL","Ammasso aperto","14 arcmin","18.4 AL","---","---","---"),
		new messier_cat("M38 - NGC 1912","Ammasso aperto Stella Marina","Auriga",5,28,42.96,35,51,18,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.40","4.6K AL","Ammasso aperto","20 arcmin","26.6 AL","---","---","---"),
		new messier_cat("M39 - NGC 7092","Ammasso aperto","Cigno",21,31,48.01,48,25,58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.59","1.1K AL","Ammasso aperto","29 arcmin","9 AL","---","---","---"),
		new messier_cat("M40 - NGC ----","Stella doppia Winnecke 4","Orsa Maggiore",12,22,12.54,58,4,58.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.64","510 AL","Stella doppia","1.7 arcmin","0.2 AL","---","---","---"),
		new messier_cat("M41 - NGC 2287","Ammasso aperto Piccolo Alveare","Cane Maggiore",6,45,0.96,-20,-45,-25.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.50","2300 AL","Ammasso aperto","39 arcmin","26.3 AL","---","---","---"),
		new messier_cat("M42 - NGC 1976","Nebulosa di Orione","Orione",5,35,17.31,-5,-23,-28.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.0","1.4K AL","Nebulosa diffusa","85 x 60 arcmin","34.7 AL","---","---","---"),
		new messier_cat("M43 - NGC 1982","Nebulosa di Mairan","Orione",5,35,30.96,-5,-16.0,-12.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.0","1.8K AL","Nebulosa diffusa","20 x 15.0 arcmin","10.2 AL","---","---","---"),
		new messier_cat("M44 - NGC 2632","Ammasso aperto Presepe","Cancro",8,40,24.01,19,40,1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.09","610 AL","Ammasso aperto","70 arcmin","12.4 AL","---","---","---"),
		new messier_cat("M45 - NGC ----","Ammasso aperto Pleiadi","Toro",3,47,0,24,7,1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.5","430 AL","Ammasso aperto","120 arcmin","15.1 AL","---","---","---"),
		new messier_cat("M46 - NGC 2437","Ammasso aperto","Poppa",7,41,46.08,-14,-48,-36,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.09","4.9K AL","Ammasso aperto","20 arcmin","28.7 AL","---","---","---"),
		new messier_cat("M47 - NGC 2422","Ammasso aperto","Poppa",7,36,35.05,-14,-28,-58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.40","1.6K AL","Ammasso aperto","25 arcmin","11.6 AL","---","---","---"),
		new messier_cat("M48 - NGC 2548","Ammasso aperto","Idra",8,13,42.97,-5,-45,-0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.8","2.5K AL","Ammasso aperto","30 arcmin","21.9 AL","---","---","---"),
		new messier_cat("M49 - NGC 4472","Galassia","Vergine",12,29,46.8,8,0,1.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","55M AL","Galassia ellittica","10.2 x 8.3 arcmin","162.8K AL","---","---","---"),
		new messier_cat("M50 - NGC 2323","Ammasso aperto Cuore","Unicorno",7,2,47.5,-8,-20,-16.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.9","3.1K AL","Ammasso aperto","14 arcmin","12.6 AL","---","---","---"),
		new messier_cat("M51 - NGC 5194","Galassia Vortice","Cani da caccia",13,29,52.70,47,11,42.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","27M AL","Galassia a spirale","11.2 x 6.9 arcmin","89.2K AL","---","---","---"),
		new messier_cat("M52 - NGC 7654","Ammasso aperto sale e pepe","Cassiopea",23,24,48.01,61,35,34.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.9","4.6K AL","Ammasso aperto","15 arcmin","19.9 AL","---","---","---"),
		new messier_cat("M53 - NGC 5024","Ammasso globulare","Chioma di Berenice",13,12,55.25,18,10,5.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.61","58K AL","Ammasso globulare","2.6 arcmin","44.4 AL","---","---","---"),
		new messier_cat("M54 - NGC 6715","Ammasso globulare","Saggittario",18,55,3.33,-30,-28,-47.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.59","86K AL","Ammasso globulare","1.6 arcmin","41.1 AL","---","---","---"),
		new messier_cat("M55 - NGC 6809","Ammasso globulare Stella rosa d'estate","Saggittario",19,39,59.7,-30,-57,-53.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.32","18K AL","Ammasso globulare","5.7 arcmin","29 AL","---","---","---"),
		new messier_cat("M56 - NGC 6779","Ammasso globulare","Lira",19,16,35.58,30,11,0.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.27","31K AL","Ammasso globulare","2.2 arcmin","19.6 AL","---","---","---"),
		new messier_cat("M57 - NGC 6720","Nebulosa Anello","Lira",18,53,35.08,33,1,45,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.8","1.4K AL","Nebulosa planetaria","1.4 x 1.1 arcmin","0.6 AL","---","---","---"),
		new messier_cat("M58 - NGC 4579","Galassia","Vergine",12,37,43.60,11,49,5.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.69","62M AL","Galassia a spirale","6 x 4.8 arcmin","108K AL","---","---","---"),
		new messier_cat("M59 - NGC 4621","Galassia","Vergine",12,42,2.33,11,38,49,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.6","48M AL","Galassia ellittica","5.4 x 3.7 arcmin","76.1K AL","---","---","---"),
		new messier_cat("M60 - NGC 4649","Galassia","Vergine",12,43,40.01,11,33,9.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.8","56M AL","Galassia ellittica","7.6 x 6.2 arcmin","124.2K AL","---","---","---"),
		new messier_cat("M61 - NGC 4303","Galassia Gonfiabile","Vergine",12,21,54.95,4,28,24.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.69","60M AL","Galassia a spirale","6.5 x 5.9 arcmin","113.8K AL","---","---","---"),
		new messier_cat("M62 - NGC 6266","Ammasso globulare Tremolante","Ofiuco",17,1,12.60,-30,-6,-44.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.44","22K AL","Ammasso globulare","1.8 arcmin","11.8 AL","---","---","---"),
		new messier_cat("M63 - NGC 5055","Galassia Girasole","Cani da caccia",13,15,49.33,42,1,45.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.60","34M AL","Galassia a spirale","12.6 x 7.2 arcmin","123.5K AL","---","---","---"),
		new messier_cat("M64 - NGC 4826","Galassia Occhio Nero","Chioma di Berenice",12,56,43.70,21,40,57.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.5","24M AL","Galassia a spirale","10 x 5.4 arcmin","70K AL","---","---","---"),
		new messier_cat("M65 - NGC 3623","Galassia","Leone",11,18,55.96,13,5,32.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.3","39M AL","Galassia a spirale","9.8 x 2.9 arcmin","111.3K AL","---","---","---"),
		new messier_cat("M66 - NGC 3627","Galassia","Leone",11,20,15.03,12,59,28.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","37M AL","Galassia a spirale","9.1 x 4.1 arcmin","96.9K AL","---","---","---"),
		new messier_cat("M67 - NGC 2682","Ammasso aperto Occhio d'oro","Cancro",8,51,18.0,11,48,0.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.9","3K AL","Ammasso aperto","25 arcmin","21.5 AL","---","---","---"),
		new messier_cat("M68 - NGC 4590","Ammasso globulare","Idra",12,39,27.98,-26,-44,-38.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.84","34K AL","Ammasso globulare","3 arcmin","29.5 AL","---","---","---"),
		new messier_cat("M69 - NGC 6637","Ammasso globulare","Saggittario",18,31,23.10,-32,-20,-53.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.63","29K AL","Ammasso globulare","1.7 arcmin","14.1 AL","---","---","---"),
		new messier_cat("M70 - NGC 6681","Ammasso globulare","Saggittario",18,43,12.76,-32,-17,-31.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.86","29K AL","Ammasso globulare","1.4 arcmin","12.1 AL","---","---","---"),
		new messier_cat("M71 - NGC 6838","Ammasso globulare Squatina","Saggittario",19,53,46.49,18,46,45.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.18","13K AL","Ammasso globulare","3.3 arcmin","12.7 AL","---","---","---"),
		new messier_cat("M72 - NGC 6981","Ammasso globulare","Acquario",20,53,27.71,-12,-32,-14.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.27","55K AL","Ammasso globulare","1.9 arcmin","30.1 AL","---","---","---"),
		new messier_cat("M73 - NGC 6994","Ammasso aperto","Acquario",20,59,0.01,-12,-37,-48,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","2K AL","Ammasso aperto","9 arcmin","5.3 AL","---","---","---"),
		new messier_cat("M74 - NGC 628","Galassia Fantasma","Pesci",1,36,41.78,15,47,0.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.39","28M AL","Galassia a spirale","10.5 x 9.5 arcmin","85.6K AL","---","---","---"),
		new messier_cat("M75 - NGC 6864","Ammasso globulare","Saggittario",20,6,4.85,-21,-55,-20.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.52","68K AL","Ammasso globulare","0.9 arcmin","18.2 AL","---","---","---"),
		new messier_cat("M76 - NGC 650","Nebulosa Manubrio","Perseo",1,42,19.95,5,34,31.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10.1","6.4K AL","Nebulosa planetaria","2.7 x 1.8 arcmin","5 AL","---","---","---"),
		new messier_cat("M77 - NGC 1068","Galassia","Balena",2,42,40.78,-0,-0,-47.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","33M AL","Galassia a spirale","7.1 x 6.0 arcmin","68K AL","---","---","---"),
		new messier_cat("M78 - NGC 2068","Nebulosa Casper","Orione",5,46,46.76,0,0,50.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.3","1.6K AL","Nebulosa diffusa","8 x 6 arcmin","3.7 AL","---","---","---"),
		new messier_cat("M79 - NGC 1904","Ammasso globulare","Lepre",5,24,10.6,-24,-31,-27.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.73","42K AL","Ammasso globulare","1.3 arcmin","15.9 AL","---","---","---"),
		new messier_cat("M80 - NGC 6093","Ammasso globulare","Scorpione",16,17,2.42,-22,-58,-33.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.32","33K AL","Ammasso globulare","1.2 arcmin","11.5 AL","---","---","---"),
		new messier_cat("M81 - NGC 3031","Galassia di Bode","Orsa Maggiore",9,55,33.17,69,3,55.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.9","12M AL","Galassia a spirale","24.9 x 11.5 arcmin","84.6K AL","---","---","---"),
		new messier_cat("M82 - NGC 3034","Galassia Sigaro","Orsa Maggiore",9,55,52.44,69,40,46.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","12M AL","Galassia a spirale","11.2 x 4.3 arcmin","37.5K AL","---","---","---"),
		new messier_cat("M83 - NGC 5236","Galassia Girandola del sud","Idra",13,37,0.92,-29,-51,-56.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.5","16M AL","Galassia a spirale","12.9 x 11.5 arcmin","58.8K AL","---","---","---"),
		new messier_cat("M84 - NGC 4374","Galassia Catena di Markarian","Vergine",12,25,3.75,12,53,13.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.10","60M AL","Galassia ellittica","6.5 x 5.6 arcmin","113.8K AL","---","---","---"),
		new messier_cat("M85 - NGC 4382","Galassia","Chioma di Berenice",12,25,24.06,18,11,27.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.10","59M AL","Galassia a spirale","7.1 x 5.5 arcmin","120.9K AL","---","---","---"),
		new messier_cat("M86 - NGC 4406","Galassia Catena di Markarian","Vergine",12,26,11.82,12,56,45.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","55M AL","Galassia ellittica","8.9 x 5.8 arcmin","142.1K AL","---","---","---"),
		new messier_cat("M87 - NGC 4486","Galassia della Vergine","Vergine",12,30,49.43,12,23,28,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.6","55M AL","Galassia ellittica","8.3 x 6.6 arcmin","133.1K AL","---","---","---"),
		new messier_cat("M88 - NGC 4501","Galassia","Chioma di Berenice",12,31,59.22,14,25,13.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.6","58M AL","Galassia a spirale","6.8 x 3.7 arcmin","114.7K AL","---","---","---"),
		new messier_cat("M89 - NGC 4552","Galassia","Vergine",12,35,39.89,12,33,21.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.8","52M AL","Galassia ellittica","3.5 x 3.5 arcmin","52.6K AL","---","---","---"),
		new messier_cat("M90 - NGC 4569","Galassia","Vergine",12,36,49.82,13,9,46.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.5","31M AL","Galassia a spirale","9.5 x 4.4 arcmin","84.9K AL","---","---","---"),
		new messier_cat("M91 - NGC 4548","Galassia","Chioma di Berenice",12,35,26.44,14,29,46.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10.19","51M AL","Galassia a spirale","5.2 x 4.2 arcmin","77.1K AL","---","---","---"),
		new messier_cat("M92 - NGC 6341","Ammasso globulare","Ercole",17,17,7.39,43,8,9.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.44","27K AL","Ammasso globulare","2 arcmin","16 AL","---","---","---"),
		new messier_cat("M93 - NGC 2447","Ammasso aperto Farfalla","Poppa",7,44,30.01,-23,-51,-25.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.19","3.4K AL","Ammasso aperto","10 arcmin","9.8 AL","---","---","---"),
		new messier_cat("M94 - NGC 4736","Galassia Occhio di Coccodrillo","Cani da caccia",12,50,53.15,41,7,12.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.19","14M AL","Galassia a spirale","14.4 x 12.1 arcmin","60.5K AL","---","---","---"),
		new messier_cat("M95 - NGC 3351","Galassia","Leone",10,43,57.74,11,42,13,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.69","31M AL","Galassia a spirale","7.4 x 5.0 arcmin","67.7K AL","---","---","---"),
		new messier_cat("M96 - NGC 3368","Galassia","Leone",10,46,45.7,11,49,11.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.3","32M AL","Galassia a spirale","7.8 x 5.2 arcmin","73K AL","---","---","---"),
		new messier_cat("M97 - NGC 3587","Nebulosa Gufo","Orsa Maggiore",11,14,47.7,55,1,8.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.8","1.9K AL","Nebulosa planetaria","3.4 x 3.3 arcmin","1.8 AL","---","---","---"),
		new messier_cat("M98 - NGC 4192","Galassia","Chioma di Berenice",12,13,48.3,14,54,1.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10.1","44M AL","Galassia a spirale","9.8 x 2.8 arcmin","126K AL","---","---","---"),
		new messier_cat("M99 - NGC 4254","Galassia","Chioma di Berenice",12,18,49.63,14,24,59.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.89","53M AL","Galassia a spirale","5.3 x 4.6 arcmin","81.2K AL","---","---","---"),
		new messier_cat("M100 - NGC 4321","Galassia Asciugacapelli","Chioma di Berenice",12,22,54.9,15,49,20.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.39","47M AL","Galassia a spirale","7.5 x 6.1 arcmin","101.9K AL","---","---","---"),
		new messier_cat("M101 - NGC 5457","Galassia Girandola","Orsa Maggiore",14,3,12.59,54,20,55.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.9","22M AL","Galassia a spirale","28.8 x 26.9 arcmin","186.4K AL","---","---","---"),
		new messier_cat("M102 - NGC 5866","Galassia Fuso","Drago",15,6,29.56,55,45,47.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.89","48M AL","Galassia a spirale","6.5 x 3.1 arcmin","90.8K AL","---","---","---"),
		new messier_cat("M103 - NGC 581","Ammasso aperto","Cassiopea",1,33,23.04,60,39,0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.4","7.2K AL","Ammasso aperto","5 arcmin","10.4 AL","---","---","---"),
		new messier_cat("M104 - NGC 4594","Galassia Sombrero","Vergine",12,39,59.44,-11,-37,-23,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.0","29M AL","Galassia a spirale","8.6 x 4.2 arcmin","72.7K AL","---","---","---"),
		new messier_cat("M105 - NGC 3379","Galassia","Leone",12,18,57.62,47,18,13.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.3","32M AL","Galassia ellittica","5.3 x 4.8 arcmin","49.8K AL","---","---","---"),
		new messier_cat("M106 - NGC 4258","Galassia","Cani da caccia",12,18,57.62,47,18,13.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","23M AL","Galassia a spirale","18.6 x 7.2 arcmin","126.7K AL","---","---","---"),
		new messier_cat("M107 - NGC 6171","Ammasso globulare Crocifisso","Ofiuco",16,32,31.86,-13,-3,-13.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.92","21K AL","Ammasso globulare","3.5 arcmin","21 AL","---","---","---"),
		new messier_cat("M108 - NGC 3556","Galassia Tavola da Surf","Orsa Maggiore",11,11,30.97,55,40,26.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10","35M AL","Galassia a spirale","8.6 x 2.4 arcmin","87K AL","---","---","---"),
		new messier_cat("M109 - NGC 3992","Galassia Aspirapolvere","Orsa Maggiore",11,57,35.99,53,22,28.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.8","75M AL","Galassia a spirale","7.5 x 4.4 arcmin","163K AL","---","---","---"),
		new messier_cat("M110 - NGC 205","Galassia","Andromeda",0,40,22.08,41,41,7.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.1","2.7M AL","Galassia ellittica","19.5 x 11.5 arcmin","15.4K AL","---","---","---")
		);






		
// FINE DATABASE CATALOGO STELLARE ----------------------------------------------------------		



		// Dichiarazioni delle variabili 	
		giorno = myParseFloat(obj.giorno.value);
		if (giorno >31 | giorno <= 0)
			{
				alert("\n GIORNO ERRATO: \n\n DATI VALIDI DA 1 A 31 \n\n CLICCA SU RESET E RIPROVA"); return; 
			}
		mese = myParseFloat(obj.mese.value);
		if (mese >12 | mese <= 0)
			{
				alert("\n MESE ERRATO: \n\n DATI VALIDI DA 1 A 12 \n\n CLICCA SU RESET E RIPROVA"); return;
			}
		anno = myParseFloat(obj.anno.value);
		
		ore = myParseFloat(obj.ore.value); 
		if (ore >=24 | ore < 0)
			{
				alert("\n ORE ERRATE: \n\n DATI VALIDI DA 0 A 23 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		minuti = myParseFloat(obj.minuti.value); 
		if (minuti >=60 | minuti < 0)
			{
				alert("\n MINUTI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		secondi = myParseFloat(obj.secondi.value); 
		if (secondi >=60 | secondi < 0)
			{
				alert("\n SECONDI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		lat_G = myParseFloat(obj.lat_G.value); 
		if (lat_G >= 90 | lat_G <= -90)
			{
				alert("\n GRADI LATITUDINE ERRATI: \n\n DATI VALIDI DA -89 A +89 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		lat_M = myParseFloat(obj.lat_M.value); 
		if (lat_M >= 60 | lat_M <= -60)
			{
				alert("\n PRIMI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		lat_S = myParseFloat(obj.lat_S.value);
		if (lat_S >= 60 | lat_S <= -60)
			{
				alert("\n SECONDI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		long_G = myParseFloat(obj.long_G.value); 
		if (long_G >= 180 | long_G <= -180)
			{
				alert("\n GRADI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -179 A +179 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		long_M = myParseFloat(obj.long_M.value); 
		if (long_M >= 60 | long_M <= -60)
			{
				alert("\n PRIMI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		long_S = myParseFloat(obj.long_S.value); 
		if (long_S >= 60 | long_S <= -60)
			{
				alert("\n SECONDI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
			
		pressione = myParseFloat(obj.PRESSIONE.value); 
		if (pressione >=1300 | pressione <= 300)
			{
				alert("\n DATO PRESSIONE INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
			}	
			

		temperatura = myParseFloat(obj.TEMPERATURA.value); 
		if (temperatura >=100 | temperatura <= -50)
			{
				alert("\n DATO TEMPERATURA INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
			}	
			
		metri = myParseFloat(obj.METRI.value); 	
		
		
		fuso = myParseFloat(obj.FUSO_ORARIO.value); 	
		
	
		
		
				
		for (var i=0; i<messier.length; i++) 
			{
						
						
			// Creazione delle variabili fisse prese dal catalogo (dati AR e DEC del 2000)
			// ore ascensione retta 	
			astro_h = messier[i].ra_h;
			// minuti ascensione retta 	
			astro_m = messier[i].ra_m;
			// secondi ascensione retta 	
			astro_s = messier[i].ra_s;
			// gradi declinazione 	
			astro_g = messier[i].de_g;
			// primi declinazione 	
			astro_p = messier[i].de_p;
			// secondi declinazione 	
			astro_ss = messier[i].de_ss;
			// ore moto proprio ascensione retta 	
			astro_mph = messier[i].mpra_h;
			// minuti moto proprio ascensione retta 
			astro_mpm = messier[i].mpra_m;
			// secondi moto proprio ascensione retta 	
			astro_mps = messier[i].mpra_s;
			// gradi moto proprio declinazione 	
			astro_mpg = messier[i].mpde_g;
			// primi moto proprio declinazione 
			astro_mpp = messier[i].mpde_p;
			// secondi moto proprio declinazione 	
			astro_mpss = messier[i].mpde_ss;
				
			// Conversione Dati di Astro del 1950 in gradi decimali sessagesimali  
			astro_ra = (astro_s / 3600 + astro_m / 60 + astro_h) * 15; 
			astro_dec = astro_ss / 3600 + astro_p / 60 + astro_g; 
			astro_mpra = (astro_mps / 3600 + astro_mpm / 60 + astro_mph)  * 15; 
			astro_mpdec = astro_mpss / 3600 + astro_mpp / 60 + astro_mpg; 
		
			// Prepara l'oggetto giorno e mese inferiori a 10 con lo zero davanti al numero per il confronto con il 15821015
			if (obj.giorno.value < 10) {obj.giorno.value = "0"+obj.giorno.value};
			if (obj.mese.value < 10) {obj.mese.value = "0"+obj.mese.value};
	
			// Unisce anno mese giorno in una stringa 
			s = (obj.anno.value+obj.mese.value+obj.giorno.value);
	
			// La stringa data unita ritorna numero 
			s = parseInt(s);  	
			
			// Toglie gli zeri al giorno creati con la ripetizione dei calcoli 
			obj.giorno.value = giorno; 
			// Toglie gli zeri al mese creati con la ripetizione dei calcoli 
			obj.mese.value = mese;
	
			// Calcolo dei giorni e ore decimali
			giorno_dec = (secondi / 3600 + minuti / 60 + ore)/24 + giorno;
			ore_dec = secondi / 3600 + minuti /60 + ore;
	
			// Return da funzione jd_ore_0 contenuta in jd_ore_0.js  
			// Creazione variabile JD_0  
			JD_0 = jd_ore_0();
	 				
			// Return da funzione jd_ore_ut contenuta in jd_ore_ut.js
			// Creazione variabile JD_UT   
			JD_UT = jd_ore_ut(); 
						
			// Scrive i risultati nel catalogo presi dai calcoli delle funzioni contenute in: asc_dec.js - alt_az.js - coord_ecl.js 
			// ascensione retta 
			messier[i].ra_h1 = ascdec()[34];
			messier[i].ra_m1 = ascdec()[35];
			messier[i].ra_s1 = ascdec()[36].toFixed(2);
			// declinazione 
			messier[i].sgn_dec = ascdec()[40];
			messier[i].de_g1 = ascdec()[37];
			messier[i].de_p1 = ascdec()[38];
			messier[i].de_ss1 = ascdec()[39].toFixed(2);
			// atezza 
			messier[i].sgn_h = altaz()[8];
			messier[i].h_g = altaz()[2];
			messier[i].h_p = altaz()[3];
			messier[i].h_ss = altaz()[4].toFixed(2);
			// azimut 
			messier[i].a_g = altaz()[5];
			messier[i].a_p = altaz()[6];
			messier[i].a_ss = altaz()[7].toFixed(2);
			// latitudine ecclittica 
			messier[i].sgn_e = coecl()[6];
			messier[i].laec_g = coecl()[0];
			messier[i].laec_p = coecl()[1];
			messier[i].laec_ss = coecl()[2].toFixed(2);
			// longitudine ecclittica
			messier[i].loec_g = coecl()[3];
			messier[i].loec_p = coecl()[4];
			messier[i].loec_ss = coecl()[5].toFixed(2);
			
			
			
			
		


					
			
		






// -------------------------- INIZIO PROGRAMMA CHE CALCOLA IL SORGERE ED IL TRAMONTO DEGLI ASTRI ----------------------------------------
			
// ----------------- ESTRAZIONE DAL DATA BASE DEI VALORI DI AR E DEC PER IL GIORNO PRIMA, IL GIORNO IN CORSO ED IL GIORNO DOPO ----------

	
	  	// CALCOLO AR DEC DEL GIORNO PRIMA A ORE O (JD_0 - 1) 

		// Ciclo che riempie il catalogo stellare con i dati calcolati 
				
				
			// Creazione delle variabili fisse prese dal catalogo (dati AR e DEC del 2000)
			// ore ascensione retta 	
			astro_h = messier[i].ra_h;
			// minuti ascensione retta 	
			astro_m = messier[i].ra_m;
			// secondi ascensione retta 	
			astro_s = messier[i].ra_s;
			// gradi declinazione 	
			astro_g = messier[i].de_g;
			// primi declinazione 	
			astro_p = messier[i].de_p;
			// secondi declinazione 	
			astro_ss = messier[i].de_ss;
			// ore moto proprio ascensione retta 	
			astro_mph = messier[i].mpra_h;
			// minuti moto proprio ascensione retta 
			astro_mpm = messier[i].mpra_m;
			// secondi moto proprio ascensione retta 	
			astro_mps = messier[i].mpra_s;
			// gradi moto proprio declinazione 	
			astro_mpg = messier[i].mpde_g;
			// primi moto proprio declinazione 
			astro_mpp = messier[i].mpde_p;
			// secondi moto proprio declinazione 	
			astro_mpss = messier[i].mpde_ss;
				
			// Conversione Dati di Astro del 1950 in gradi decimali sessagesimali  
			astro_ra = (astro_s / 3600 + astro_m / 60 + astro_h) * 15; 
			astro_dec = astro_ss / 3600 + astro_p / 60 + astro_g; 
			astro_mpra = (astro_mps / 3600 + astro_mpm / 60 + astro_mph)  * 15; 
			astro_mpdec = astro_mpss / 3600 + astro_mpp / 60 + astro_mpg; 
		
			// Prepara l'oggetto giorno e mese inferiori a 10 con lo zero davanti al numero per il confronto con il 15821015
			if (obj.giorno.value < 10) {obj.giorno.value = "0"+obj.giorno.value};
			if (obj.mese.value < 10) {obj.mese.value = "0"+obj.mese.value};
	
			// Unisce anno mese giorno in una stringa 
			s = (obj.anno.value+obj.mese.value+obj.giorno.value);
	
			// La stringa data unita ritorna numero 
			s = parseInt(s);  	
			
			// Toglie gli zeri al giorno creati con la ripetizione dei calcoli 
			obj.giorno.value = giorno; 
			// Toglie gli zeri al mese creati con la ripetizione dei calcoli 
			obj.mese.value = mese;
	
			// Calcolo dei giorni e ore decimali
			giorno_dec = (secondi / 3600 + minuti / 60 + ore)/24 + giorno;
			ore_dec = secondi / 3600 + minuti /60 + ore;
	
			// Return da funzione jd_ore_0 contenuta in jd_ore_0.js  
			// Creazione variabile JD_0  
			JD_0 = jd_ore_0();
	 				
			// Return da funzione jd_ore_ut contenuta in jd_ore_ut.js
			// Creazione variabile JD_UT   
			JD_UT = jd_ore_ut(); 
		
			
			// Scrive i risultati nel catalogo presi dai calcoli delle funzioni contenute in: asc_dec.js - alt_az.js - coord_ecl.js 
			// ascensione retta 
			messier[i].ra_h1 = ascdec_1()[34];
			messier[i].ra_m1 = ascdec_1()[35];
			messier[i].ra_s1 = ascdec_1()[36].toFixed(2);
			// declinazione 
			messier[i].sgn_dec = ascdec_1()[40];
			messier[i].de_g1 = ascdec_1()[37];
			messier[i].de_p1 = ascdec_1()[38];
			messier[i].de_ss1 = ascdec_1()[39].toFixed(2);
			// atezza 
			messier[i].sgn_h = altaz()[8];
			messier[i].h_g = altaz()[2];
			messier[i].h_p = altaz()[3];
			messier[i].h_ss = altaz()[4].toFixed(2);
			// azimut 
			messier[i].a_g = altaz()[5];
			messier[i].a_p = altaz()[6];
			messier[i].a_ss = altaz()[7].toFixed(2);
			// latitudine ecclittica 
			messier[i].sgn_e = coecl()[6];
			messier[i].laec_g = coecl()[0];
			messier[i].laec_p = coecl()[1];
			messier[i].laec_ss = coecl()[2].toFixed(2);
			// longitudine ecclittica
			messier[i].loec_g = coecl()[3];
			messier[i].loec_p = coecl()[4];
			messier[i].loec_ss = coecl()[5].toFixed(2);
			
			
			
			
			

		// CICLO CHE PRENDE I VALORI DI AR E DEC A JD_0 - 1
						var alma_coeq_1 = messier[i].ra_h1 + ":" + messier[i].ra_m1 + ":" + messier[i].ra_s1 + '\n' + messier[i].sgn_dec + messier[i].de_g1 + "°" + messier[i].de_p1 + "'" + messier[i].de_ss1 + "''" ;
						var alma_ar_1 = (messier[i].ra_s1 / 3600 + messier[i].ra_m1 / 60 + messier[i].ra_h1) * 15 ;
						var alma_dec_1 = messier[i].de_ss1 / 3600 +  messier[i].de_p1 / 60 + messier[i].de_g1;      
						if (messier[i].sgn_dec == "- "){alma_dec_1 = alma_dec_1 * -1}
			



//  ------------------------  CALCOLO AR DEC DEL GIORNO ATTUALE A ORE O (JD_0) -----------------------------------

				
				
				
			// Creazione delle variabili fisse prese dal catalogo (dati AR e DEC del 2000)
			// ore ascensione retta 	
			astro_h = messier[i].ra_h;
			// minuti ascensione retta 	
			astro_m = messier[i].ra_m;
			// secondi ascensione retta 	
			astro_s = messier[i].ra_s;
			// gradi declinazione 	
			astro_g = messier[i].de_g;
			// primi declinazione 	
			astro_p = messier[i].de_p;
			// secondi declinazione 	
			astro_ss = messier[i].de_ss;
			// ore moto proprio ascensione retta 	
			astro_mph = messier[i].mpra_h;
			// minuti moto proprio ascensione retta 
			astro_mpm = messier[i].mpra_m;
			// secondi moto proprio ascensione retta 	
			astro_mps = messier[i].mpra_s;
			// gradi moto proprio declinazione 	
			astro_mpg = messier[i].mpde_g;
			// primi moto proprio declinazione 
			astro_mpp = messier[i].mpde_p;
			// secondi moto proprio declinazione 	
			astro_mpss = messier[i].mpde_ss;
				
			// Conversione Dati di Astro del 1950 in gradi decimali sessagesimali  
			astro_ra = (astro_s / 3600 + astro_m / 60 + astro_h) * 15; 
			astro_dec = astro_ss / 3600 + astro_p / 60 + astro_g; 
			astro_mpra = (astro_mps / 3600 + astro_mpm / 60 + astro_mph)  * 15; 
			astro_mpdec = astro_mpss / 3600 + astro_mpp / 60 + astro_mpg; 
		
			// Prepara l'oggetto giorno e mese inferiori a 10 con lo zero davanti al numero per il confronto con il 15821015
			if (obj.giorno.value < 10) {obj.giorno.value = "0"+obj.giorno.value};
			if (obj.mese.value < 10) {obj.mese.value = "0"+obj.mese.value};
	
			// Unisce anno mese giorno in una stringa 
			s = (obj.anno.value+obj.mese.value+obj.giorno.value);
	
			// La stringa data unita ritorna numero 
			s = parseInt(s);  	
			
			// Toglie gli zeri al giorno creati con la ripetizione dei calcoli 
			obj.giorno.value = giorno; 
			// Toglie gli zeri al mese creati con la ripetizione dei calcoli 
			obj.mese.value = mese;
	
			// Calcolo dei giorni e ore decimali
			giorno_dec = (secondi / 3600 + minuti / 60 + ore)/24 + giorno;
			ore_dec = secondi / 3600 + minuti /60 + ore;
	
			// Return da funzione jd_ore_0 contenuta in jd_ore_0.js  
			// Creazione variabile JD_0  
			JD_0 = jd_ore_0();
	 				
			// Return da funzione jd_ore_ut contenuta in jd_ore_ut.js
			// Creazione variabile JD_UT   
			JD_UT = jd_ore_ut(); 
		
			
			// Scrive i risultati nel catalogo presi dai calcoli delle funzioni contenute in: asc_dec.js - alt_az.js - coord_ecl.js 
			// ascensione retta 
			messier[i].ra_h1 = ascdec_2()[34];
			messier[i].ra_m1 = ascdec_2()[35];
			messier[i].ra_s1 = ascdec_2()[36].toFixed(2);
			// declinazione 
			messier[i].sgn_dec = ascdec_2()[40];
			messier[i].de_g1 = ascdec_2()[37];
			messier[i].de_p1 = ascdec_2()[38];
			messier[i].de_ss1 = ascdec_2()[39].toFixed(2);
			// atezza 
			messier[i].sgn_h = altaz()[8];
			messier[i].h_g = altaz()[2];
			messier[i].h_p = altaz()[3];
			messier[i].h_ss = altaz()[4].toFixed(2);
			// azimut 
			messier[i].a_g = altaz()[5];
			messier[i].a_p = altaz()[6];
			messier[i].a_ss = altaz()[7].toFixed(2);
			// latitudine ecclittica 
			messier[i].sgn_e = coecl()[6];
			messier[i].laec_g = coecl()[0];
			messier[i].laec_p = coecl()[1];
			messier[i].laec_ss = coecl()[2].toFixed(2);
			// longitudine ecclittica
			messier[i].loec_g = coecl()[3];
			messier[i].loec_p = coecl()[4];
			messier[i].loec_ss = coecl()[5].toFixed(2);
			
			
			
		// Fine del ciclo for - next ------------------------- 	

 						var alma_coeq_2 = messier[i].ra_h1 + ":" + messier[i].ra_m1 + ":" + messier[i].ra_s1 + '\n' + messier[i].sgn_dec + messier[i].de_g1 + "°" + messier[i].de_p1 + "'" + messier[i].de_ss1 + "''" ;
 						var alma_ar_2 = (messier[i].ra_s1 / 3600 + messier[i].ra_m1 / 60 + messier[i].ra_h1) * 15;
 						var alma_dec_2 = messier[i].de_ss1 / 3600 +  messier[i].de_p1 / 60 + messier[i].de_g1;      
 						if (messier[i].sgn_dec == "- "){alma_dec_2 = alma_dec_2 * -1}
 					
 
 
//  ------------------------------------ CALCOLO AR DEC DEL GIORNO DOPO A ORE O (JD_0 + 1) ------------------------------------------------

				
				
				
 			// Creazione delle variabili fisse prese dal catalogo (dati AR e DEC del 2000)
			// ore ascensione retta 	
			astro_h = messier[i].ra_h;
			// minuti ascensione retta 	
			astro_m = messier[i].ra_m;
			// secondi ascensione retta 	
			astro_s = messier[i].ra_s;
			// gradi declinazione 	
			astro_g = messier[i].de_g;
			// primi declinazione 	
			astro_p = messier[i].de_p;
			// secondi declinazione 	
			astro_ss = messier[i].de_ss;
			// ore moto proprio ascensione retta 	
			astro_mph = messier[i].mpra_h;
			// minuti moto proprio ascensione retta 
			astro_mpm = messier[i].mpra_m;
			// secondi moto proprio ascensione retta 	
			astro_mps = messier[i].mpra_s;
			// gradi moto proprio declinazione 	
			astro_mpg = messier[i].mpde_g;
			// primi moto proprio declinazione 
			astro_mpp = messier[i].mpde_p;
			// secondi moto proprio declinazione 	
			astro_mpss = messier[i].mpde_ss;
				
			// Conversione Dati di Astro del 1950 in gradi decimali sessagesimali  
			astro_ra = (astro_s / 3600 + astro_m / 60 + astro_h) * 15; 
			astro_dec = astro_ss / 3600 + astro_p / 60 + astro_g; 
			astro_mpra = (astro_mps / 3600 + astro_mpm / 60 + astro_mph)  * 15; 
			astro_mpdec = astro_mpss / 3600 + astro_mpp / 60 + astro_mpg; 
		
			// Prepara l'oggetto giorno e mese inferiori a 10 con lo zero davanti al numero per il confronto con il 15821015
			if (obj.giorno.value < 10) {obj.giorno.value = "0"+obj.giorno.value};
			if (obj.mese.value < 10) {obj.mese.value = "0"+obj.mese.value};
	
			// Unisce anno mese giorno in una stringa 
			s = (obj.anno.value+obj.mese.value+obj.giorno.value);
	
			// La stringa data unita ritorna numero 
			s = parseInt(s);  	
			
			// Toglie gli zeri al giorno creati con la ripetizione dei calcoli 
			obj.giorno.value = giorno; 
			// Toglie gli zeri al mese creati con la ripetizione dei calcoli 
			obj.mese.value = mese;
	
			// Calcolo dei giorni e ore decimali
			giorno_dec = (secondi / 3600 + minuti / 60 + ore)/24 + giorno;
			ore_dec = secondi / 3600 + minuti /60 + ore;
	
			// Return da funzione jd_ore_0 contenuta in jd_ore_0.js  
			// Creazione variabile JD_0  
			JD_0 = jd_ore_0();
	 				
			// Return da funzione jd_ore_ut contenuta in jd_ore_ut.js
			// Creazione variabile JD_UT   
			JD_UT = jd_ore_ut(); 
		
 			
			// Scrive i risultati nel catalogo presi dai calcoli delle funzioni contenute in: asc_dec.js - alt_az.js - coord_ecl.js 
			// ascensione retta 
			messier[i].ra_h1 = ascdec_3()[34];
			messier[i].ra_m1 = ascdec_3()[35];
			messier[i].ra_s1 = ascdec_3()[36].toFixed(2);
			// declinazione 
			messier[i].sgn_dec = ascdec_3()[40];
			messier[i].de_g1 = ascdec_3()[37];
			messier[i].de_p1 = ascdec_3()[38];
			messier[i].de_ss1 = ascdec_3()[39].toFixed(2);
			// atezza 
			messier[i].sgn_h = altaz()[8];
			messier[i].h_g = altaz()[2];
			messier[i].h_p = altaz()[3];
			messier[i].h_ss = altaz()[4].toFixed(2);
			// azimut 
			messier[i].a_g = altaz()[5];
			messier[i].a_p = altaz()[6];
			messier[i].a_ss = altaz()[7].toFixed(2);
			// latitudine ecclittica 
			messier[i].sgn_e = coecl()[6];
			messier[i].laec_g = coecl()[0];
			messier[i].laec_p = coecl()[1];
			messier[i].laec_ss = coecl()[2].toFixed(2);
			// longitudine ecclittica
			messier[i].loec_g = coecl()[3];
			messier[i].loec_p = coecl()[4];
			messier[i].loec_ss = coecl()[5].toFixed(2);
 			
			
			
			
		// Fine del ciclo for - next ------------------------- 	
 
		// CICLO CHE PRENDE I VALORI DI AR E DEC A JD_0 + 1 
 						var alma_coeq_3 = messier[i].ra_h1 + ":" + messier[i].ra_m1 + ":" + messier[i].ra_s1 + '\n' + messier[i].sgn_dec + messier[i].de_g1 + "°" + messier[i].de_p1 + "'" + messier[i].de_ss1 + "''" ;
 						var alma_ar_3 = (messier[i].ra_s1 / 3600 + messier[i].ra_m1 / 60 + messier[i].ra_h1) * 15 ;
 						var alma_dec_3 = messier[i].de_ss1 / 3600 +  messier[i].de_p1 / 60 + messier[i].de_g1;      
 						if (messier[i].sgn_dec == "- "){alma_dec_3 = alma_dec_3 * -1}
			

// ---------------------------- INIZIO DELLE FORMULE PER IL CALCOLO DEL SORGERE MERIDIANO E TRAMONTO ASTRONOMICO ------------------------

			// FATTORI PER LA TRASFORMAZIONE COORDINATE RADIANTI
			var r = Math.PI / 180; 
			var r1 = 180 / Math.PI;
 			
			// Conversione latitudine in gradi decimali 	
			var lat_dec = lat_S / 3600 + lat_M / 60 + lat_G;
				
			// Conversione longitudine in gradi decimali

			var long_dec = long_S / 3600 + long_M /60 + long_G;

			// trasformazione longitudine in negativo per calcolare l'angolo orario 
			long_dec = long_dec * - 1;
 			
			// ALTEZZA GEOMETRICA PER STELLE E PIANETI
			var alma_h0 = 0;
			
			// DELTA T 
			var alma_dt = et()[4];

			// GIORNI GIULIANI 
			var alma_jd_1 = JD_0 - 1 ; 
			var alma_jd_2 = JD_0; 
			var alma_jd_3 = JD_0 + 1 ; 
			
			// TEMPO SIDEREO AD ORE 0 
			var alma_TS_0 = (ts_ut_c_0()[2] / 3600 + ts_ut_c_0()[1] / 60 + ts_ut_c_0()[0]) * 15;
						
 
 
			// SECONDO MEMBRO FORMULA ANGOLO ORARIO GIORNO IN CORSO PER IL TEST CIRCUMPOLARE
			var alma_H0 = (Math.sin(alma_h0*r) - Math.sin(lat_dec*r) * Math.sin(alma_dec_2*r)) / (Math.cos(lat_dec*r) * Math.cos(alma_dec_2*r));


			if (alma_H0>+1 || alma_H0<-1)
			{ 
 			var sorgere = "circumpolare";     
			var meridiano = "circumpolare";   
			var tramonto = "circumpolare";  
			
			messier[i].sorg_cat = sorgere;
			messier[i].meri_cat = meridiano;
			messier[i].tram_cat = tramonto;
			
 			}
			else 
			{

			// ANGOLO ORARIO GIORNO IN CORSO 
			alma_H0 = Math.acos(alma_H0)*r1;

			// FRAZIONI DI TEMPO DA MOLTIPLICARE A 24 PER AVERE DEGLI ORARI APPROSSIMATI DI MERIDIANO,SORGERE E TRAMONTO
			var alma_m0 =  (alma_ar_2 + long_dec - alma_TS_0) / 360; 
			if(alma_m0 < 0){alma_m0 = alma_m0 + 1 }
			if(alma_m0 > 1){alma_m0 = alma_m0 - 1 }

			var alma_m1 = alma_m0 - alma_H0 / 360;
			if(alma_m1 < 0){alma_m1 = alma_m1 + 1 }
			if(alma_m1 > 1){alma_m1 = alma_m1 - 1 }

			var alma_m2 = alma_m0 + alma_H0 / 360;
			if(alma_m2 < 0){alma_m2 = alma_m2 + 1 }
			if(alma_m2 > 1){alma_m2 = alma_m2 - 1 }

			// CALCOLO TEMPO SIDEREO  MERIDIANO,SORGERE E TRAMONTO
			var alma_ts_0 = alma_TS_0 + 360.985647 * alma_m0;  
			if(alma_ts_0 > 360){alma_ts_0 = alma_ts_0 - 360}
			var alma_ts_1 = alma_TS_0 + 360.985647 * alma_m1;  
			if(alma_ts_1 > 360){alma_ts_1 = alma_ts_1 - 360}
			var alma_ts_2 = alma_TS_0 + 360.985647 * alma_m2;  
			if(alma_ts_2 > 360){alma_ts_2 = alma_ts_2 - 360}

			// CALCOLO DEL FATTORE DI INTERPOLAZIONE (n) PER IL MERIDIANO, SORGERE E TRAMONTO 
			var alma_n0 = alma_m0 + alma_dt / 86400; 
			var alma_n1 = alma_m1 + alma_dt / 86400; 
			var alma_n2 = alma_m2 + alma_dt / 86400; 
			
			// INTERPOLAZIONE DI ASCENSIONE RETTA PER IL MERIDIANO, SORGERE E TRAMONTO 

			// CONDIZIONI CHE SERVONO PER FARE IN MODO CHE LE AR DEI GIORNI DOPO SIANO SEMPRE SUPERIORI AI GIORNI PRECEDENTI 
			// IN QUESTO CASO QUESTE CONDIZIONI NON SI POSSONO METTERE PERCHE' A VOLTE IL SISTEMA NON FUNZIONA, VEDI MIRACH 8/11/2016
			// TROVATA LA SOLUZIONE AUMENTANDO DI 180 IL VALORE DA CONFRONTARE 
			// -------------------------------------------------------------------------------------------------------------
			if (alma_ar_2 + 180 < alma_ar_1){alma_ar_2 = alma_ar_2 + 360}
			if (alma_ar_3 + 180 < alma_ar_2){alma_ar_3 = alma_ar_3 + 360}
			// -------------------------------------------------------------------------------------------------------------
			var alma_ar_a = alma_ar_2 - alma_ar_1; 
			var alma_ar_b = alma_ar_3 - alma_ar_2; 
			var alma_ar_c = alma_ar_b - alma_ar_a; 
			
			var alma_ar_int0 = alma_ar_2 + alma_n0 / 2 * (alma_ar_a + alma_ar_b + alma_n0 * alma_ar_c);
			var alma_ar_int1 = alma_ar_2 + alma_n1 / 2 * (alma_ar_a + alma_ar_b + alma_n1 * alma_ar_c);
			var alma_ar_int2 = alma_ar_2 + alma_n2 / 2 * (alma_ar_a + alma_ar_b + alma_n2 * alma_ar_c);
			
			// INTERPOLAZIONE DI DECLINAZIONE PER IL SORGERE E TRAMONTO 
			var alma_dec_a = alma_dec_2 - alma_dec_1; 
			var alma_dec_b = alma_dec_3 - alma_dec_2; 
			var alma_dec_c = alma_dec_b - alma_dec_a; 
			
			var alma_dec_int1 = alma_dec_2 + alma_n1 / 2 * (alma_dec_a + alma_dec_b + alma_n1 * alma_dec_c);
			var alma_dec_int2 = alma_dec_2 + alma_n2 / 2 * (alma_dec_a + alma_dec_b + alma_n2 * alma_dec_c);
			
			// CALCOLO ANGOLO ORARIO DEL MERIDIANO, SORGERE E TRAMONTO 
			var alma_Hour0 = alma_ts_0 - long_dec - alma_ar_int0; 
			var alma_Hour1 = alma_ts_1 - long_dec - alma_ar_int1; 
			var alma_Hour2 = alma_ts_2 - long_dec - alma_ar_int2; 
			
			// CALCOLO ALTEZZA DEL SORGERE 
			var alma_h1 = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(alma_dec_int1*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(alma_dec_int1*Math.PI/180)*Math.cos(alma_Hour1*Math.PI/180))*180/Math.PI;	
			// CALCOLO ALTEZZA DEL TRAMONTO 
			var alma_h2 = Math.asin(Math.sin(lat_dec*Math.PI/180)*Math.sin(alma_dec_int2*Math.PI/180)+Math.cos(lat_dec*Math.PI/180)*Math.cos(alma_dec_int2*Math.PI/180)*Math.cos(alma_Hour2*Math.PI/180))*180/Math.PI;	
			
			// CALCOLO DELTA (m) MERIDIANO, SORGERE E TRAMONTO 
			var alma_delta0 = - alma_Hour0 / 360;
			var alma_delta1 = (alma_h1 - alma_h0) / (360 * Math.cos(alma_dec_int1*r) * Math.cos(lat_dec*r) * Math.sin(alma_Hour1*r));
			var alma_delta2 = (alma_h2 - alma_h0) / (360 * Math.cos(alma_dec_int2*r) * Math.cos(lat_dec*r) * Math.sin(alma_Hour2*r));

 			// AGGIUNTA AI VALORI DI (m) I RELATIVI DELTA (m) PER IL MERIDIANO, SORGERE E TRAMONTO E RELATIVA CONVERSIONE IL 24 ESIMI 
			var alma_sorgere = (alma_m1 + alma_delta1) * 24; 
			var alma_meridiano = (alma_m0 + alma_delta0) * 24;
			var alma_tramonto = (alma_m2 + alma_delta2) * 24; 
			
			// CONDIZIONI CHE SERVONO QUANDO L'ORARIO E' NEGATIVO OPPURE OLTRE LA 24 ESIMA ORA 
			// -------------------------------------------------------------------------------
			// SORGERE  			
			if(alma_sorgere < 0){alma_sorgere = alma_sorgere + 24}
			if(alma_sorgere >= 24 ){alma_sorgere = alma_sorgere - 24}
			
			// MERIDIANO 
			if(alma_meridiano < 0){alma_meridiano = alma_meridiano + 24}
			if(alma_meridiano >= 24 ){alma_meridiano = alma_meridiano - 24}
			
			// TRAMONTO
			if(alma_tramonto < 0){alma_tramonto = alma_tramonto + 24}
			if(alma_tramonto >= 24 ){alma_tramonto = alma_tramonto - 24}
			// --------------------------------------------------------------------------------

			// CONVERSIONE DEI TEMPI IN ORE E RISULTATI FINALI IN LINEA 
 			var sorgere_H = Math.floor(alma_sorgere); 
			var sorgere_M_dec = (alma_sorgere - sorgere_H) * 60; 
			var sorgere_M = Math.floor(sorgere_M_dec); 
			var sorgere_S = (sorgere_M_dec - sorgere_M) * 60; 
			
//			var sorgere_cambio_data = "stesso giorno"; 
			var sorgere_HL = sorgere_H + fuso;
			if(sorgere_HL < 0) {sorgere_HL = sorgere_HL + 24} 
			if(sorgere_HL >= 24) {sorgere_HL = sorgere_HL - 24 }

			var sorgere =  myParseFloat_null((sorgere_HL)) + " : " + myParseFloat_null(sorgere_M) + " : " + myParseFloat_null(sorgere_S.toFixed(2));

 			var meridiano_H = Math.floor(alma_meridiano); 
			var meridiano_M_dec = (alma_meridiano - meridiano_H) * 60; 
			var meridiano_M = Math.floor(meridiano_M_dec); 
			var meridiano_S = (meridiano_M_dec - meridiano_M) * 60; 
			
//			var meridiano_cambio_data = "stesso giorno"; 
			var meridiano_HL = meridiano_H + fuso;
			if(meridiano_HL < 0) {meridiano_HL = meridiano_HL + 24}
  			if(meridiano_HL >= 24) {meridiano_HL = meridiano_HL - 24 }

			var meridiano =  myParseFloat_null((meridiano_HL)) + " : " + myParseFloat_null(meridiano_M) + " : " + myParseFloat_null(meridiano_S.toFixed(2));
			

 			var tramonto_H = Math.floor(alma_tramonto); 
			var tramonto_M_dec = (alma_tramonto - tramonto_H) * 60; 
			var tramonto_M = Math.floor(tramonto_M_dec); 
			var tramonto_S = (tramonto_M_dec - tramonto_M) * 60; 
			
//			var tramonto_cambio_data = "stesso giorno"; 
			var tramonto_HL = tramonto_H + fuso;
			if(tramonto_HL < 0) {tramonto_HL = tramonto_HL + 24 }
			if(tramonto_HL >= 24) {tramonto_HL = tramonto_HL - 24 }

			var tramonto =  myParseFloat_null((tramonto_HL)) + " : " + myParseFloat_null(tramonto_M) + " : " + myParseFloat_null(tramonto_S.toFixed(2));


			messier[i].sorg_cat = sorgere;
			messier[i].meri_cat = meridiano;
			messier[i].tram_cat = tramonto;


		}
		
			}




// -------------------------------------------- FINE CALCOLO SORGERE MERIDIANO E TRAMONTO ASTRONOMICO  -----------------------------------------------------------------------------



		// Apre una pagina web per visualizzare i risultati del catalogo 
  		var swin=window.open("","stars","menubar,scrollbars,resizable,width=1600,height=500");
  		with (swin.document) 
			{
    			writeln("<HTML>");
    			writeln("<HEAD>");
    			writeln("<TITLE>Calcolo Effemeridi - Oggetti Messier</TITLE>");
				

				// colore del testo 
				writeln("<style> body,td,th {color: #FFF;}</style>");
				// colore del fondopagina 
				writeln("<style> body {background-color:#666}; </style>");
				// colore della tabella 
				writeln("<style>#table{background-color:#999; border-radius: 8px;border:2px solid;border-color:#000;color: #FFF;box-shadow:5px 5px 10px #000;}  </style>");
				// colore dei link 				
				writeln("<style>a:link {color: #FFF;}a:visited {color: #FFF;}a:hover{color:#0F0; </style>");
				
				
    			writeln("</HEAD>");
				//if(anno == 0 ) {anno = -1}
				//else if(anno < 0 ) {anno = anno -1}

    			writeln("<BODY>");
    			writeln("<CENTER>");
				
				// Creazione della tabella contenente il titolo della tabella 
				writeln("<table border=\"0\" cellpadding=\"5\" ");
    			writeln("<TR>");
			
				if (lat_G < 0 | lat_M < 0 | lat_S < 0)
					{
						segn_lat = " Sud";
						lat_G = Math.abs(lat_G); 
						lat_M = Math.abs(lat_M); 
						lat_S = Math.abs(lat_S); 
					}
				else {segn_lat = " Nord" }	

				if (long_G < 0 | long_M < 0 | long_S < 0)
					{
						segn_long = " Ovest";
						long_G = Math.abs(long_G); 
						long_M = Math.abs(long_M); 
						long_S = Math.abs(long_S); 
					}
				else {segn_long = " Est" }	

    			writeln("<TD align=center> <b> Dati del "+ giorno + "/" + mese + "/" + anno + " alle ore TDT " + ore + ":" + minuti + ":" + secondi + " in posizione geografica " + lat_G + "º" + lat_M + "'" + lat_S + "''" + segn_lat + "    " +  long_G + "º" + long_M + "'" + long_S + "''" + segn_long + 			
				"<br>" + "Rosso = oggetto sotto l'orizzonte - Verde chiaro = oggetto sopra l'orizzonte con azimut minore di 180° - Verde scuro = oggetto sopra l'orizzonte con azimut maggiore di 180°" +
				"<br>"  +  "Gli orari del sorgere, meridiano e tramonto sono locali al tempo fuso " +  fuso + "</TD>");	
    			writeln("</TR></TABLE>");
				// Fine tabella titolo 

				writeln("<A HREF=\"javascript:window.print()\">Stampa</A> <A HREF=\"javascript:window.close()\">Chiudi</A>");

				
				// Creazione della tabella dati 
    			writeln("<table border=\"0\" cellpadding=\"5\"  id=\"table\" ");
				



				// Intestazioni
    			writeln("<TR>");
				
				
				
    			writeln("<TD bgcolor=#059CE4 align=center><strong>Nr. Catalogo</TD>");
    			writeln("<TD bgcolor=#059CE4 align=center><strong>Nome</TD>");
    			writeln("<TD bgcolor=#059CE4 align=center><strong>Costellaz.</TD>");
				
				
				
				writeln("<TD bgcolor=#059CE4 align=center><strong>Altezza </TD>");	
				writeln("<TD bgcolor=#059CE4 align=center><strong>Azimut </TD>");	
				
				writeln("<TD bgcolor=#059CE4 align=center><strong>Sorgere T. Civ. </TD>");	
				writeln("<TD bgcolor=#059CE4 align=center><strong>Meridiano T. Civ. </TD>");	
				writeln("<TD bgcolor=#059CE4 align=center><strong>Tramonto T. Civ. </TD>");	
				
				
    			writeln("<TD bgcolor=#059CE4 align=center><strong>Magnitudine</TD>");
				
				
				
				
    			writeln("<TD bgcolor=#059CE4 align=center><strong>Dim. apparenti</TD>");
				
				
    
				// Ciclo for - next dei Risultati
				for (var i=0; i<messier.length; i++) 
					{
						
						if (messier[i].h_g >= 60 && messier[i].sgn_h == "+ " && messier[i].a_g >= 180 )
						{
						// Numero di catalogo
						writeln("<TR bgcolor=#360 ><TD  width='150' align=center>"+messier[i].catnum+"</TD>");
      					
						// Nome dell'oggetto oggetto
						writeln("<TD  width='250' align=center>"+messier[i].name+"</TD>");
      					
						// Costellazione
						writeln("<TD  width='100' align=center>"+messier[i].cons+"</TD>");
						

						// Altezza della stella 
      					writeln("<TD  width='110' align=center>"+messier[i].sgn_h+messier[i].h_g+"º "+messier[i].h_p+"' "+messier[i].h_ss+"'' "+"</TD>");

						// Azimut della stella 
      					writeln("<TD  width='110' align=center>"+messier[i].a_g+"º "+messier[i].a_p+"' "+messier[i].a_ss+"'' "+"</TD>");

						// sorgere
      					writeln("<TD  width='110' align=center>"+messier[i].sorg_cat+"</TD>");

						// meridiano
      					writeln("<TD  width='110' align=center>"+messier[i].meri_cat+"</TD>");

						// tramonto
      					writeln("<TD  width='110' align=center>"+messier[i].tram_cat+"</TD>");

						// Magnitudine
						writeln("<TD  width='80' align=center>"+messier[i].mg+"</TD>");

						// Dimensioni apparenti 
      					writeln("<TD  width='110' align=center>"+messier[i].dimapp+"</TD>");
						}
						
						if (messier[i].h_g >= 60 && messier[i].sgn_h == "+ " && messier[i].a_g < 180 )
						{
						// Numero di catalogo
						writeln("<TR bgcolor=#090 ><TD  width='150' align=center>"+messier[i].catnum+"</TD>");
      					
						// Nome dell'oggetto oggetto
						writeln("<TD  width='250' align=center>"+messier[i].name+"</TD>");
      					
						// Costellazione
						writeln("<TD  width='100' align=center>"+messier[i].cons+"</TD>");
						

						// Altezza della stella 
      					writeln("<TD  width='110' align=center>"+messier[i].sgn_h+messier[i].h_g+"º "+messier[i].h_p+"' "+messier[i].h_ss+"'' "+"</TD>");

						// Azimut della stella 
      					writeln("<TD  width='110' align=center>"+messier[i].a_g+"º "+messier[i].a_p+"' "+messier[i].a_ss+"'' "+"</TD>");

						// sorgere
      					writeln("<TD  width='110' align=center>"+messier[i].sorg_cat+"</TD>");

						// meridiano
      					writeln("<TD  width='110' align=center>"+messier[i].meri_cat+"</TD>");

						// tramonto
      					writeln("<TD  width='110' align=center>"+messier[i].tram_cat+"</TD>");

						// Magnitudine
						writeln("<TD  width='80' align=center>"+messier[i].mg+"</TD>");

						// Dimensioni apparenti 
      					writeln("<TD  width='110' align=center>"+messier[i].dimapp+"</TD>");
						}
						
						






						
    				
					// Fine del ciclo for - next 
					}
					
					
/*					
				// scrive una riga per definire con gli spazi la larghezza di ogni singola colonna 
				writeln("<TR >");
				
				
				// Spazi per la foto
    			writeln("<TD align=center bgcolor=#059CE4 >&nbsp;</TD>");
				
				// Spazi per il num. catalogo
    			writeln("<TD align=center bgcolor=#059CE4 >&nbsp;</TD>");

				// Spazi per il nome dell'oggetto
    			writeln("<TD  align=center bgcolor=#059CE4></TD>"); 
				
				// Spazi per la costellazione
    			writeln("<TD  align=center bgcolor=#059CE4 >                                </TD>");


				
				// Spazi per l'altezza  
				writeln("<TD  align=center bgcolor=#059CE4>                                </TD>");

				// Spazi per l'azimut 
				writeln("<TD  align=center bgcolor=#059CE4>                                </TD>");
				
				// Spazi per il sorgere
				writeln("<TD  align=center bgcolor=#059CE4>                                </TD>");
				
				// Spazi per il meridiano
				writeln("<TD  align=center bgcolor=#059CE4>                                </TD>");
				
				
				// Spazi per il tramonto
				writeln("<TD  align=center bgcolor=#059CE4>                                </TD>");
				
				
				// Spazi per magnitidine
    			writeln("<TD  align=center bgcolor=#059CE4 >            </TD>");
				    			
				// Spazi per le dimensioni apparenti 
				writeln("<TD  align=center bgcolor=#059CE4 >&nbsp;</TD>");
				
				
*/
					
					
					
					
				// Fine della tabella dei risultati 
    			writeln("</TABLE><P>");
				
				// Creazione della tabella di fine pagina 
    			writeln("<TABLE border=\"0\" cellpadding=\"5\" ><TR>");
    			writeln("<tr> <td> <b> Agostino Frosini  -  JavaScript Software 2020  - </TD>");
    			writeln("</TR></TABLE></CENTER></BODY></HTML>");
    			close();
  			}
  		swin.focus();












		}
	else 
		{
			alert("ERRORE\n\nHAI TENTATO DI MODIFICARE LA PAGINA WEB\n\nSPIACENTE IL PROGRAMMA NON FUNZIONERA' PIU'"); 
		}		
}
